#!/usr/bin/python

from numpy import zeros, array,product,diagonal
from math import *
from LUdecomp import *
from scipy import linalg
#defines vandermode matrix for the l
def vandermode(v):
    n = len(v)
    a = zeros((n,n))
    for j in range(n):
        a[:,j] = v**(n-j-1)
    return a


v = array([1.0, 1.2, 1.4, 1.6, 1.8, 2.0])

A = vandermode(v)
print A
aOrig = A.copy()

b = array([0.0, 1.0, 0.0, 1.0, 0.0, 1.0])
bOrig = b.copy

A = LUdecomp(A)
x = LUsolve(A,b)
print "x","=",x

b = array([[1.0, 0.0, 0.0, 0.0, 0.0, 0.0], \
           [0.0, 1.0, 0.0, 0.0, 0.0, 0.0], \
           [0.0, 0.0, 1.0, 0.0, 0.0, 0.0], \
           [0.0, 0.0, 0.0, 1.0, 0.0, 0.0], \
           [0.0, 0.0, 0.0, 0.0, 1.0, 0.0], \
           [0.0, 0.0, 0.0, 0.0, 0.0, 1.0]])

A = aOrig.copy()
A = LUdecomp(A)

det = product(diagonal(A))

print "\nDeterminant =",det

for i in range(len(b)):
    x = LUsolve(A,b[i])
    print "x",i+1,"=",x














